<?php

/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.5.1
 */

defined('ABSPATH') || exit;

global $product;

$attachment_ids = $product->get_gallery_image_ids();
$attachment_ids = empty($attachment_ids) ? (array) $product->get_image_id() : $attachment_ids;

if ($attachment_ids && $product->get_image_id()) {
	foreach ($attachment_ids as $attachment_id) { ?>
		<div>
			<div class="wrapper_image">
				<?php echo wp_get_attachment_image($attachment_id, 'full') ?>
			</div>
		</div>
<?php
	}
}
